'use strict';_={selAct:` You can leave this field empty in order to perform no action. This <br> is useful if you want a keyboard or mouse shortcut to do nothing. <hr b=2>\n Also, an action doesn't need to have a trigger if you enter a name <br> in its description field. These named actions can be inserted as <br>\n items in any <c h=menu>AutoControl menu</c>. Learn how at <a href="${_Ce.actMenu}">Action menus</a>. <hr b=2>\n Additionally, named actions can be executed programmatically <br> from <a href="${_Ce.scrtDoc}">AutoControl scripts</a>\n using the <apiRef execAction> function.\n `,
newStp:" Link actions together. <{MORE}> <hr b><hr b> <{actChain}>\n ",actChain:` When 2 or more actions are linked together, they form an action chain.<hr b=2>\n Actions in the chain are performed from left to right and each one <br>\n passes on its <c h=tgtTab1>target tabs</c> to the next. <hr b=4>\n <b>Example:</b> &nbsp; &nbsp;\n <mid><act>open new tab</act> <sep></sep> <act>activate tabs</act> <sep></sep> <act>pin tabs</act></mid>\n <hr b=4>\n First, a new tab is opened, then that tab is activated, and finally <br> the tab is pinned.<hr b><hr b=2>\n See <a href='${_Ce.actions}'>this page</a> to learn more about action sequences.\n `,
tgtTab0:" The <b>target tabs</b> of an action are the tabs the action is <br> applied to. You specify them in the <u b>Apply to:</u> select box.\n ",tgtTab1:" <{tgtTab0}> <hr b=2>\n Not all actions let you choose their target tabs. Those <br> that do not, are applied to the <c h=/tse/cur>current tab</c>.\n ",tgtTabs:" <{tgtTab0}> <hr b=2>\n However, when an action is not the first one in its <c h=actChain>chain</c>, <br> the target tabs come from the previous action in the chain.\n ",tgtsFld:" Choose one or more tabs to apply the action to. <br> These are known as the <b>target tabs</b>. <hr b=2>\n For <c h=winAct1>window actions</c>, these tabs are used to <br> determine the action's <c h=tgtWin>target windows</c>.\n ",
tgtWin:" The <b>target windows</b> of a <c h=winAct1>window action</c> are the windows the <br> action is applied to.\n They are determined from the <c h=tgtTabs>target tabs</c>. <br> That is, the action will be applied to all windows containing <br> the target tabs.\n ",addAct:` Append an action. <{MORE}> <hr b=2>\n You can put multiple actions in sequence to be executed <br> from top to bottom.\n Each step in the sequence can be a <br> single action or an <c h=actChain>action chain</c> with its own <c h=tgtTab1>target tabs</c>. <hr b=3>\n See <a href='${_Ce.actions}'>this page</a> to learn more about action sequences.\n `,
winAct0:" <b>Window actions</b> are those that apply to a window as a <br> whole, not to its tabs.\n ",winAct1:" <{winAct0}> <hr b>\n For example, <act xsml inln>minimize</act>, <act xsml inln>maximize</act>, <act xsml inln>move/resize</act>.\n ",winAct2:" <{winAct0}> \x3c!-- <hr b> The action's <c h=tgtWin>target windows</c> are specified in the <br> <u b>Apply to:</u> field. --\x3e\n ",menu:` AutoControl can display a floating menu with a <br> list of tabs, closed tabs, bookmarks or actions. <hr b>\n You can create menus with any combination of <br> those elements and show them on the screen <br> at any moment.\n <hr b>\n See menu examples <a href="${_Ce.tbBtns}">here</a> and <a href="${_Ce.actMenu}">here</a>. \n `,
exClbrd:" The <b>extra clipboards</b> are memory slots kept by AutoControl. You <br> can put any amount of\n text in them and then use that text in other <br> actions by means of the <c hl0 mnsp>&lt;clipboard(<b>n</b>)&gt;</c>\n <c h=/plcHld>placeholder</c>. <hr b=3>\n For example, you can use the <act xsml inln>insert text</act> action to insert the <br> <u>Extra clipboard 1</u> at the cursor position\n or the <act xsml inln>clipbrd put</act> action <br> to put the content of one clipboard into another clipboard.\n ",
txtLn:' <b>Lines of text</b> are separated from each other by the <br> <a href="<{/URLS/newln}>">newline character</a> (the ENTER key).\n <hr b>\n For example, the following text contains 3 lines: <hr b=2>\n <c hl ib>\n <c red>This is the first line of text, which looks like two <br> lines, but there\'s no newline character in it.</c> <br>\n <c grn>This is the second line of text.</c> <br>\n <br>\n <c blu>And this is the third one.</c>\n </c>\n ',tbStGrp:' The browser allows you to create groups of tabs in the tab-strip <br> (at the top of the browser window)\n by right-clicking on a tab and <br> selecting "Add tab to group". <hr b>\n Learn more about this feature on <a href="<{/URLS/tabGrps}>">this page</a>.\n ',
tmplExpr:{tit:" <c h=/plcHld>Placeholder</c> for the title of the <c h=@/tgtTabs>target tab</c>.",url:" <c h=/plcHld>Placeholder</c> for the <c h=/url>URL</c> of the <c h=@/tgtTabs>target tab</c>.",domn:" <c h=/plcHld>Placeholder</c> for the <c h=/domPrt>domain</c> part of the <c h=@/tgtTabs>target tab</c>.",mdom:" <c h=/plcHld>Placeholder</c> for the <c h=/mDomPrt>main domain</c> part of the <c h=@/tgtTabs>target tab</c>.",path:" <c h=/plcHld>Placeholder</c> for the <c h=/pthPrt>path</c> part of the <c h=@/tgtTabs>target tab</c>.",
dPth:" <c h=/plcHld>Placeholder</c> for the directory path of the <c h=@/tgtTabs>target tab</c>. <br>\n This is the <c h=/pthPrt>path</c> part minus the file name. i.e. everything <br> in the path up to the last slash character.\n ",prot:" <c h=/plcHld>Placeholder</c> for the <c h=/urlPrts>protocol</c> part of the <c h=@/tgtTabs>target tab</c>.",qry:" <c h=/plcHld>Placeholder</c> for the <c h=/urlPrts>query</c> part of the <c h=@/tgtTabs>target tab</c>.",frag:" <c h=/plcHld>Placeholder</c> for the <c h=/urlPrts>fragment</c> part of the <c h=@/tgtTabs>target tab</c>.",
sltn:" <c h=/plcHld>Placeholder</c> for the cursor selection in the <c h=/focWin>focused window</c>, as plain text. <hr b>\n For example, in a browser window the cursor selection is the selected text <br> minus any non-textual elements such as images.\n <{MORE}> <hr b>\n In a spreadsheet window (such as MS Excel or similar), it's the text content <br> of the selected cells. <hr b>\n In a file explorer window, it's the file paths of the selected files/folders. <hr b>\n If the current selection cannot be converted to text, the placeholder will <br> be replaced by empty text (zero characters). <hr b=2>\n Not all kinds of windows are supported; for example, text selection in a <br> <a href=\"<{/URLS/cmdPrmt}>\">command prompt</a> window cannot be obtained.\n ",
ombar:` <{/noSuprt}>\n <c h=/plcHld>Placeholder</c> for the text in the <c h=/ombar>omnibox</c> of the <c h=/curWin>current window</c>. <hr b>\n This is the text currently visible in the omnibox, i.e. either the URL <br> of the <c h=/actTab>active tab</c>\n or any other text that was typed into the box. <hr b>\n See <a href="${_Ce.omboxShrt}">this page</a> for a few examples of using this placeholder.\n `,obWrd:" <c h=/plcHld>Placeholder</c> for the omnibox text converted into a <br> list of words. This will cause the action to repeat <br>\n what it does once for each element in the list. <hr b=2>\n This is analogous to what <c hl0 mnsp>&lt;clipboard.lines&gt;</c> <br> or <c hl0 mnsp>&lt;clipboard.words&gt;</c> do.\n ",
clbrd:' <c h=/plcHld>Placeholder</c> for the content of the <c h=/clpbrd>clipboard</c>.\n <{MORE}> <hr b=2>\n It optionally accepts a number in parentheses: <c hl mnsp>&lt;clipboard(<c b red>n</c>)&gt;</c> <hr b=2>\n Where <c b red>n</c> is the number of one of the <c h=@/exClbrd>extra clipboards</c> supported <br> by AutoControl (from 1 to 5).\n \x3c!--\n <hr b>\n You can use the <act xsml inln>clipbrd put</act> action, and others in the <br> "<c blk blr>Clipboard Actions</c>" category,\n to put text in those clipboards.\n --\x3e\n ',
exClb1:" <c h=/plcHld>Placeholder</c> for the content of the <c h=@/exClbrd>Extra clipboard 1</c>. <hr b>\n The number in parentheses can go from <b red>1</b> to <b red>5</b> for <br> each extra clipboard.\n ",clbLns:" <c h=/plcHld>Placeholder</c> for the content of the <c h=/clpbrd>clipboard</c> separated into lines of text.\n <{MORE}> <hr b=2>\n When the clipboard contains multiple <c h=@/txtLn>lines of text</c>, <c hl0>&lt;clipboard.lines&gt;</c> <br> gives those lines separated\n as a list of elements. This will cause the <br> action to repeat itself once for each of those elements (text lines).\n <hr b=2>\n For example, if there are multiple URLs in the clipboard (one by line), <br> an action like\n <act xsml inln>open url</act> will open each of those URLs.\n <hr b=3>\n All actions behave this way. The only requirement is that the clipboard <br> contains more than one <c h=@/txtLn>line of text</c>.\n <{proTip}>\n ",
clbWrd:" <c h=/plcHld>Placeholder</c> for the content of the <c h=/clpbrd>clipboard</c> separated into words. <hr b=2>\n Produces the same effect as <c hl0 mnsp>&lt;clipboard.lines&gt;</c> but for each <br> word instead of each line. \n ",date:" <c h=/plcHld>Placeholder</c> for the current date with format <c blu>Y-M-D</c>. <{MORE}> <hr b=2>\n You can specify a custom format between parentheses <br> and quotes, like this: <c hl>&lt;date('<c blu>M/D/Y H:I:S</c>')&gt;</c> <hr b=2>\n <table>\n <tr><td b blu>Y:<td>Year <td b blu>H:<td>Hours\n <tr><td b blu>M:<td>Month &nbsp; &nbsp; &nbsp; &nbsp; <td b blu>I:<td>Minutes\n <tr><td b blu>D:<td>Day <td b blu>S:<td>Seconds\n </table>\n ",
var:` <c h=/plcHld>Placeholder</c> for a variable created with the <apiRef pubVar> <br> scripting function.\n You must replace <c hl0 mnsp blu>var_name</c> with the <br> name of your variable. <{MORE}>\n <hr b>\n If <c hl0 mnsp blu>var_name</c> is a <a doc href="<{/URLS/jsStr}>">string</a>, use <c hl0 mnsp>&lt;var.<c blu>var_name</c>.<c red>lines</c>&gt;</c> to <br>\n achieve the same effect as <c hl0 mnsp>&lt;clipboard.lines&gt;</c>. <hr b=2>\n If <c hl0 mnsp blu>var_name</c> is an <a doc href="<{/URLS/jsObj}>">Object</a>, use <c hl0 mnsp>&lt;var.<c blu>var_name</c>.<c red>property</c>&gt;</c> <br>\n to get one of its properties. <hr b=2>\n If <c hl0 mnsp blu>var_name</c> is an <a doc href="<{/URLS/jsArr}>">Array</a>, use <c hl0 mnsp>&lt;var.<c blu>var_name</c>.<c red>join(' ')</c>&gt;</c> <br>\n to join the elements into a single piece of text.\n <hr b=2>\n See <a href="${_Ce.scrtDoc}/pubVar">this page</a> for an example of using this placeholder.\n `,
dir:` <c h=/plcHld>Placeholder</c> for the <c h=/fsPath>absolute path</c> of a system directory. You must <br> replace <c hl0 mnsp blu>dir_name</c> with one of the following: <hr b=3>\n <c hl0 mnsp blk blr>profile</c>: The current user's profile folder. e.g. <c blk blr>C:\\Users\\John</c> <hr b>\n <c hl0 mnsp blk blr>desktop</c>: The current user's desktop folder. <hr b>\n <c hl0 mnsp blk blr>documents</c>: The current user's "My Documents" folder. <hr b>\n <c hl0 mnsp blk blr>appdata</c>: The current user's Application data folder. <hr b>\n <c hl0 mnsp blk blr>windir</c>: The OS's installation directory. e.g. <c blk blr>C:\\Windows</c> <hr b>\n <!--c hl0 mnsp blk blr>progFiles</c>: The Program Files folder. e.g. <c blk blr>C:\\Program Files</c> <hr b-->\n <c hl0 mnsp blk blr>progFilesX86</c> <c ib>The Program Files folder for 32-bit programs. <br> &nbsp;e.g. <c blk blr>C:\\Program Files (x86)</c></c> <hr b>\n <c hl0 mnsp blk blr>recent</c>: The current user's "Recent items" folder. <hr b>\n <c hl0 mnsp blk blr>startup</c>: The current user's startup folder. <hr b=3>\n More info at <a href="${_Ce.scrtDoc}/placeholders#sysDir">this page</a>.\n `,
env:' <c h=/plcHld>Placeholder</c> for an environment variable. <c hl0 mnsp blu>env_name</c> can be any of <br>\n the standard <a href="<{/URLS/envVar}>">environment variables</a> as well as any variable defined at <br>\n <c hl0>Control Panel <b>&gt;</b> User Accounts <b>&gt;</b> Change my environment variables</c> <br>\n or by typing "Environment variables" in the Start menu. <hr b=2>\n <b>Examples:</b> <hr b=2>\n <c hl0 mnsp blk blr>env.temp</c>: C:\\Users\\&lt;USER&gt;\\AppData\\Local\\Temp <hr b>\n <c hl0 mnsp blk blr>env.username</c>: The name of the current user account. <hr b>\n <c hl0 mnsp blk blr>env.ProgramW6432</c>: C:\\Program Files <hr b>\n <c hl0 mnsp blk blr>env.ComSpec</c>: C:\\Windows\\system32\\cmd.exe <hr b>\n <c hl0 mnsp blk blr>env.OS</c>: Windows_NT <hr b>\n <c hl0 mnsp blk blr>env.NUMBER_OF_PROCESSORS</c>: 2 <hr b>\n \n ',
proTip:" <{MORE}> <hr b=3>\n <b>PRO TIP:</b> <hr b>\n When you combine 2 or more placeholders that give a list of <br> elements, such as this: <hr b>\n <c hl mnsp>&lt;clipboard.<c red>lines</c>&gt;&lt;clipboard(<b>1</b>).<c red>words</c>&gt;</c>\n <hr b=2>\n the result will be the <b>cartesian product</b> of those lists. <hr b=2>\n For example, if the <u>system clipboard</u> contains: <hr b>\n <c hl ib><c prpl>http://google.com/?q=</c> <br> <c blu>http://bing.com/?q=</c></c> <hr b=2>\n and the <u>Extra clipboard 1</u> contains: <c hl0><c grn>John</c> <c orng>Paul</c> <c red>Peter</c></c> <hr b>\n Then the result of the above expression will be: <hr b>\n <c hl ib>\n <c prpl>http://google.com/?q=</c><c grn>John</c> <br>\n <c prpl>http://google.com/?q=</c><c orng>Paul</c> <br>\n <c prpl>http://google.com/?q=</c><c red>Peter</c> <br>\n <c blu>http://bing.com/?q=</c><c grn>John</c> <br>\n <c blu>http://bing.com/?q=</c><c orng>Paul</c> <br>\n <c blu>http://bing.com/?q=</c><c red>Peter</c> <br>\n </c>\n ",
fname:' <c h=/plcHld>Placeholder</c> for the filename (without extension) of the URL being saved: <hr b=2>\n <c mnsp hl>http://example.com/path/<c blu b u>picture</c>.png</c> <{MORE}> <hr b=4>\n You can also use <c mnsp hl0>&lt;fileName.replace("...","...")&gt;</c> to fix common <br> issues with filenames.\n For example, if the URL is: <hr b=2>\n <c mnsp hl>http://example.com/path/<c blu>Chapter<c red>%20</c>1<c red>%20</c>-<c red>%20</c>Page<c red>%20</c>2</c>.pdf</c> <hr b=3>\n You can replace the <c red mnsp hl0>%20</c> parts with spaces using this expression: <hr b>\n <c mnsp hl0>&lt;fileName.replace("%20"," ")&gt;</c> <hr b=2>\n Which results in: <c blu mnsp hl>Chapter 1 - Page 2</c> <hr b=3>\n <c mnsp hl0>&lt;fileName.unescape&gt;</c> does the same, but for all\n <a href="<{/URLS/prcntEnc}>">percent-encoded</a> <br> characters.\n ',
fext:' <c h=/plcHld>Placeholder</c> for the file extension of the URL being saved: <hr b=2>\n <c mnsp hl>http://example.com/path/picture<c blu b u>.png</c></c>\n <{MORE}> <hr b=4>\n This expression turns the extension into lower-case letters: <hr b>\n <c mnsp hl0>&lt;fileExt.toLowerCase&gt;</c> <hr b=2>\n This expression turns the extension into capital letters: <hr b>\n <c mnsp hl0>&lt;fileExt.toUpperCase&gt;</c> <hr b=2>\n This expression changes <c mnsp b blk blr>jpeg</c> to <c mnsp b blk blr>jpg</c>: <hr b>\n <c mnsp hl0>&lt;fileExt.replace("jpeg","jpg")&gt;</c> <hr b=2>\n This turns it into lower-case, then changes <c mnsp b blk blr>jpeg</c> to <c mnsp b blk blr>jpg</c>: <hr b>\n <c mnsp hl0>&lt;fileExt.toLowerCase.replace("jpeg","jpg")&gt;</c>\n ',
txt:' <c h=/plcHld>Placeholder</c> for the text line that is to be turned into a URL. <hr b>\n It also accepts sub-expressions, as all placeholders do. <hr b> For example: <hr b=2>\n Turn the text line into a list of all the words in it: <br>\n <c mnsp hl0>&lt;text.words&gt;</c> <hr b=2>\n Convert all letters to lowercase: <br>\n <c mnsp hl0>&lt;text.toLowerCase&gt;</c> <hr b=2>\n Replace dashes with spaces: <br>\n <c mnsp hl0>&lt;text.replace("-"," ")&gt;</c> <hr b=3>\n Convert special characters to <a href="<{/URLS/prcntEnc}>">percent encoding</a>: <br>\n <c mnsp hl0>&lt;text.escape&gt;</c> <hr b=2>\n Example: <c hl0>C++ & C#</c> changes to <c hl0>C<c red>%2B</c><c grn>%2B</c>+<c blu>%26</c>+C<c prpl>%23</c></c>\n ',
L_desk:" <c h=/plcHld>Placeholder</c> for the current user's desktop folder.",L_doc:' <c h=/plcHld>Placeholder</c> for the current user\'s "My Documents" folder.',L_prof:" <c h=/plcHld>Placeholder</c> for the current user's profile folder. <hr b> e.g. <c hl0 mnsp>C:\\Users\\John</c>",L_app:" <c h=/plcHld>Placeholder</c> for the current user's Application data folder. <hr b> e.g. <c hl0 mnsp>C:\\Users\\John\\AppData\\Local</c>",L_win:" <c h=/plcHld>Placeholder</c> for the OS's installation folder. <hr b> e.g. <c hl0 mnsp>C:\\Windows</c>",
L_drv:" <c h=/plcHld>Placeholder</c> for the main system drive. e.g. <c hl0 mnsp b>C:</c>",L_prog:" <c h=/plcHld>Placeholder</c> for the Program Files folder. <hr b> e.g. <c hl0 mnsp>C:\\Program Files</c>",L_prg86:" <c h=/plcHld>Placeholder</c> for the Program Files folder for 32-bit programs. <hr b> e.g. <c hl0 mnsp>C:\\Program Files (x86)</c>",L_star:" <c h=/plcHld>Placeholder</c> for the current user's startup folder.",L_rec:' <c h=/plcHld>Placeholder</c> for the current user\'s "Recent items" folder',
L_tmp:" <c h=/plcHld>Placeholder</c> for the folder containing the <br> current user's temporal files."},actList:{goBack:{_:" Navigate back to the previous page in <br> the browsing history of the <c h=/tse/cur>current tab</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Go back</act> advanced action to <br> navigate back any set of tabs."},goForward:{_:" Navigate forward to the next page in <br> the browsing history of the <c h=/tse/cur>current tab</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Go forward</act> advanced action <br> to navigate forward any set of tabs."},
reload:{_:' Reload the page in the <c h=/tse/cur>current tab</c>. Equivalent to clicking <br> the "reload" button in the browser\'s toolbar.\n This is called <br> a "soft reload", i.e. it uses the <a href="https://wikipedia.org/wiki/Wikipedia:Bypass_your_cache">browser cache</a>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Reload tabs</act> advanced action to perform a soft <br> or hard reload on any set of tabs.'},zoomIn:{_:" Perform per-domain zoom on the <c h=/tse/cur>current tab</c>. <br> i.e. it affects all pages under the same <c h=/domPrt>domain</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Zoom tabs</act> advanced action to perform <br> either per-tab or per-domain zoom on any set of tabs."},
zoomOut:{_:"<{../zoomIn/_}>"},pin:{_:" Pin/unpin the <c h=/tse/cur>current tab</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Pin tabs</act> advanced action <br> to pin any set of tabs."},mute:{_:" Mute/unmute the <c h=/tse/cur>current tab</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Mute tabs</act> advanced <br> action to mute any set of tabs."},duplicate:{_:" Create a duplicate of the <c h=/tse/cur>current tab</c>, <br> including its back/forward history.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Duplicate tabs</act> advanced <br> action to duplicate any set of tabs."},
detach:{_:" Take the <c h=/tse/cur>current tab</c> out of its window.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Detach tabs</act> advanced action <br> to detach any set of tabs."},openNTP:{_:" Open a new tab at the rightmost position in the <c h=/curWin>current window</c>. <hr b=2>\n <b>Tip:</b> <br>\n Use the <act xsml inln>Open URL</act> advanced action plus the <c hl mnsp>chrome://newtab</c> <br>\n URL to open a new tab at any position in any window.\n ",pg:" Whether to open Chrome's default <br> new tab page or a blank page."},
switchPrev:{_:` Switch to the tab you were using right before the current one. <hr b>\n See <a href="${_Ce.mruTabs}">this page</a> for advanced tab switching in <c h=/mruOrd>MRU order</c>.\n <hr b=2> <b>Tip:</b> <br>\n You can use the <act xsml inln>Activate tabs</act> and <act xsml inln>Focus</act> advanced actions <br> to switch to any tab on any window.`},close:{_:" Close the <c h=/tse/cur>current tab</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Close tabs</act> advanced action <br> to close any other tab or set of tabs.\n ",
swto:" Choose which tab to switch to after closing <br> the current tab. <br> The default behavior may vary by browser <br>\n brand and whether the current tab was <br> opened by another tab or not."},closeLefts:{_:" Close all tabs to the left <br> of the <c h=/tse/cur>current tab</c>."},closeRights:{_:" Close all tabs to the right <br> of the <c h=/tse/cur>current tab</c>."},closeOther:{_:" Close all tabs in the current window <br> except the <c h=/actTab>active tab</c>."},closeWin:{_:" Close the <c h=/curWin>current window</c>.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Close tabs</act> advanced action <br> to close multiple windows."},
activateTabs:{_:" Make one or more tabs <c h=/actTab>active</c> in their own window. <hr b>\n You can activate multiple tabs simultaneously, <br> provided they are in different windows.\n ",pk:` Whenever a tab is activated, it is moved to the top of <br> the <c h=/mruOrd>MRU order</c>.\n That is, it becomes the most recently <br> activated tab. <hr b>\n Check this option if you want to activate a tab <u>without</u> <br> changing its place in the MRU order. <hr b=2>\n See <a href="${_Ce.mruTabs}#MRU-tabs">here</a> for a nifty example of using this.\n `},
reloadTabs:{mode:" <b>Normal reload</b>: reloads the page using the browser <br> cache (the local copy stored in your computer). <hr b=2>\n <b>Hard reload</b>: forces to reload the page from the <br> server, ignoring the local cache.\n "},goUpURL:{_:" Go to the <c h=/url>URL</c> one level up. <hr b=2> For example, if you are in <blu>http://example.com/section/subsection/</blu>, <br>\n the upper URL is <blu>http://example.com/section/</blu>"},loadUrls:{_:" Open one or more <c h=/url>URLs</c> either in existing <br> tabs or new tabs/windows.\n ",
url:' The <c h=/url>URL</c> may contain <c h=/plcHld>placeholder</c> expressions like <b>&lt;domain&gt;</b>, <b>&lt;clipboard&gt;</b> <br>\n and others intermixed with the rest of the URL. <hr b=2>\n For example, the following expression gives the URL of the <c h=@/tgtTabs>target tab</c> with <br> <b>HTTPS:</b> appended at the beginning: <hr b=2>\n <c hl>https://<c blu>&lt;domain></c><c red>&lt;path></c><c grn>&lt;url.query></c><c orng>&lt;url.fragment></c></c>\n <{MORE}> <hr b=4>\n If you specify multiple <c h=@/tgtTabs>target tabs</c> for this action, then any placeholder that <br> refers to those tabs\n (such as the <b>&lt;url&gt;</b> placeholder) will cause the action to <br> repeat itself once for each target tab. <hr b>\n For example, the following expression will open a Google search for each <br> of the target tabs\' title: <hr b>\n <c hl>http://google.com/search?q=<c red>&lt;title&gt;</c></c>\n <{MORE}> <hr b=4>\n There are a number of special URLs, such as: <hr b>\n <it></it><c hl0 mnsp blu>chrome://newtab</c> The new tab page. <hr b>\n <it></it><c hl0 mnsp blu>about:blank</c> A blank page. <hr b>\n <it></it><c hl0 mnsp blu>chrome://downloads</c> All file downloads. <hr b>\n <it></it><c hl0 mnsp blu>chrome://bookmarks</c> The bookmark manager. <hr b=2>\n Know them all <a href="chrome://chrome-urls/">here</a>.\n ',
opnTgtTbs:" You have to specify (in the action's <c h=@/tgtTabs>target tabs</c>) which tab to use for <br> opening the URL.\n If you specify more than one tab, the URL will be <br> opened on each of those tabs.  \n <hr b=2>\n However, if the URL includes <c h=/plcHld>placeholders</c> that expand to multiple <br> URLs (such as\n <c hl0>&lt;<c h=@/tmplExpr/clbLns>clipboard.lines</c>&gt;</c>), then each of those URLs will be <br> opened in one of the\n <c h=@/tgtTabs>target tabs</c>.\n <{MORE}> <hr b=2>\n Also, remember that in an <c h=@/actChain>action chain</c>, the target tabs are passed <br> on from one action to the next.\n So, the target tabs of the <act xsml inln>Open URL</act> <br> action may be either those specified in the <u b>Apply to</u>\n select box or <br> the ones that came from a previous action in the chain.\n ",
nwTb:" If the amount of <c h=@/tgtTabs>target tabs</c> passed to the action are not enough <br>\n to open all URLs, new tabs will be created as needed. <hr b>\n <b>Example:</b> <br>\n If the action receives zero target tabs (either from the <u b>Apply to</u> <br> select box or from the previous action in the\n <c h=@/actChain>chain</c>) and this <br> checkbox is disabled, then the action will do nothing, i.e. the URL <br>\n will be opened in zero tabs. If the checkbox is enabled, then a <br> new tab will be created.\n ",
icgn:" Open in an incognito window. <hr b> <{/reqIncg}>\n "},opnOnLft:" Open in a new tab (or tabs) to the <br> left of a reference tab.",opnOnRgt:" Open in a new tab (or tabs) to the <br> right of a reference tab.",highlightTabs:{_:" <c h=/selTab>Select</c> multiple tabs in one go. That is, <br> without clicking on them one by one.\n ",mode:" Whether to <b>select</b>, <b>unselect</b> or change to <br> the opposite state (<b>toggle</b>).\n ",actT:" Apply the action to the <c h=/actTab>active tab</c> in <br> addition to the <c h=@/tgtTabs>target tabs</c>."},
pinTabs:{mode:" Whether to <b>pin</b>, <b>unpin</b> or change to <br> the opposite state (<b>toggle</b>)."},zoomTabs:{tpe:"\n <b u>Proportional</b>: Increase or decrease the zoom by an <br> amount proportional to the current zoom level. <hr b=2>\n <b u>Fixed</b>: Increase or decrease the zoom by a fixed amount. <hr b=2>\n <b u>Custom zoom</b>: Set the zoom to a specific percentage. <hr b=2>\n <b u>Reset to default</b>: Set the zoom to the default level <br> specified in the browser settings. \n ",
rel:" The proportion by which to increase or decrease the zoom. <br> For example, if the current zoom is 50%, then increasing it <br>\n by 10% will give a new zoom of 55%. <hr b>\n <b>Note:</b> <br>\n This proportional amount is approximate, not mathematically <br> exact. The amount will de adjusted so that the resulting zoom <br>\n is a round number. \n ",fix:" How many percentage points to increase or <br> decrease the zoom. <br> For example, if the current zoom is 50%, then <br>\n increasing it by 10 points will give a new zoom <br> of 60%.\n ",
cst:" The new zoom level to apply (the same for all <c h=@/tgtTabs>target tabs</c>).",scp:" Whether to apply the zoom to the tab only <br> or to all pages in the <c h=/domPrt>domain</c>."},muteTabs:{_:" Silence any audio coming from one or more tabs.",mode:" Whether to <b>mute</b>, <b>unmute</b> or change to <br> the opposite state (<b>toggle</b>)."},moveTabs:{_:` Change the position of one or more tabs in a window, <br> or move them to a different window. <hr b>\n See <a href="${_Ce.domTabs}">this page</a> for some nifty ways of using this action.\n `,
bef:" Move to the left of a reference tab.",aft:" Move to the right of a reference tab."},detachTabs:{_:" Take one or more tabs out of their window."},groupTabs:{_:" Add or remove tabs from existing <c h=@/tbStGrp>tab-strip groups</c> <br> or create new <c h=@/tbStGrp>tab-strip groups</c>.\n ",nw:' Add the <c h=@/tgtTabs>target tabs</c> to one or more new <c h=@/tbStGrp>tab-strip groups</c>. <hr b=2>\n <b>PRO TIP:</b> <br>\n You can create multiple <c h=@/tbStGrp>tab-strip groups</c> in one go by specifying a custom <br> <u>tab selection</u> as the <c h=@/tgtTabs>target tabs</c>.\n You must use the "<c blr blk sml>GROUP BY</c>" operation <br> in the <u>tab selection</u> in order to separate the tabs in groups.\n Each of those <br> groups will be used to create a new <c h=@/tbStGrp>tab-strip group</c>.\n ',
no:" Take the <c h=@/tgtTabs>target tabs</c> out of their respective <c h=@/tbStGrp>tab-strip group</c>.",lf:" Move the <c h=@/tgtTabs>target tabs</c> into the <c h=@/tbStGrp>tab-strip group</c> of <br> a reference tab (by the left side).",rt:" Move the <c h=@/tgtTabs>target tabs</c> into the <c h=@/tbStGrp>tab-strip group</c> of <br> a reference tab (by the right side).",rfTb:" Specify the reference tab next to which the <c h=@/tgtTabs>target tabs</c> <br> will be moved and grouped together.",nNg:" Group the tabs only if the reference tab (specified above) <br> already belongs to a <c h=@/tbStGrp>tab-strip group</c>. <br>\n If this option is not checked, a new tab-strip group will <br> be created if needed."},
duplicateTabs:{_:" Create a duplicate of one or more tabs, <br> including their back/forward history."},openInIncognito:{_:" Open one or more tabs in an incognito window. <hr b> <{/reqIncg}>"},closeTabs:{_:" Close one or more tabs in one or more windows <br> and, optionally, keep those windows open if there <br> are no more tabs in them. <hr b>\n In order to close an entire window, you must apply <br> this action to all tabs in the desired window.\n ",swto:" If one or more of the tabs being closed are <c h=/actTab>active tabs</c>, <br>\n this lets you specify which tab will become the new <br> active tab in their respective window.\n ",
kpW:" If a window is about to be closed because all its tabs were closed, this <br>\n option forces the window to remain open by creating an empty tab in it. <hr b>\n This empty tab is passed to the next action in the <c h=@/actChain>chain</c>, so you can <br>\n optionally open any URL in it, by doing this: <hr b=2>\n <center><mid><act>Close tabs</act> <sep></sep> <act>Open URL</act></mid></center> <hr b=4>\n <b>Last window:</b> keep open only the last remaining browser window. <hr b>\n <b>Any window:</b> keep open all browser windows.\n ",
dft:" The default behavior varies with browser brand. <br> It's usually <u>Opener tab</u> else <u>Right tab</u> else <u>Left tab</u>.",prv:" The tab you were using right before <br> the <c h=/actTab>active tab</c> in a window.",opnr:" The tab that opened the <c h=/actTab>active tab</c>, as long <br> as it's in the same window.",lft:" The tab to the left of the <c h=/actTab>active tab</c>.",rgt:" The tab to the right of the <c h=/actTab>active tab</c>."},reopen:{_:" Reopen the last closed tab or window. Its position <br> and back/forward history are remembered.\n <hr b=2> <b>Tip:</b> <br>\n Use the <act xsml inln>Reopen tabs</act> advanced action to reopen <br> multiple tabs and windows.\n "},
undoClose:{_:" Reopen one or more tabs/windows that you closed <br> recently (up to 25 closing actions are remembered). <hr b>\n The back/forward history and position of each tab <br> and window are also restored.\n ",typ:" <b>Tabs</b>: Reopen tabs one by one, even if they were closed as <br> part of a window. <hr b>\n <b>Windows</b>: Reopen windows only. <hr b>\n <b>Any</b>: Reopen anything, whether it's a closed tab or window.\n ",amn:" Number of elements to reopen. Depending on <u b>Reopen type:</u>, <br> this is a number of tabs, windows or both.\n ",
curW:" Only reopen tabs that were in the <c h=/curWin>current window</c>. <br> This doesn't apply to reopening windows.\n ",flt:" Only reopen tabs or windows whose <c h=/domPrt>domain</c> matches the <br> specified condition. <br>\n You can use the <c hl b mnsp>&lt;domain&gt;</c> <c h=/plcHld>placeholder</c> in this text field, <br>\n which represents the <c h=/domPrt>domain</c> of the <c h=/tse/cur>current tab</c>.\n "},unloadTabs:{_:` <c h=/uldTab>Unload</c> the content of a tab (the web page), but keep <br> the tab open.<hr b>\n This is useful to release system resources when you've <br> opened lots of tabs, thus alleviating the workload of your <br> computer. <hr b>\n The next time you activate an unloaded tab, its content <br> will be reloaded automatically. <hr b=2>\n See <a href="${_Ce.relseRam}">this page</a> for a convenient way of using this. <hr b=2>\n This action is not supported in Windows XP and Vista.\n <!-- <hr b=2> The <c h=/actTab>active tab</c> can <b>NOT</b> be unloaded. All others can.-->`},
favoriteTabs:{_:" Add or remove tabs from/to a favorite list. <hr b=2> <{/favLst}>\n ",lst:" Choose which list to operate on. Each favorite <br> list is independent from the others.\n ",opr:" <b>Add</b>: The <c h=@/tgtTabs>target tabs</c> are added to the end of the list. Tabs that <br>\n already are in the list are not added again. <hr b=2>\n <b>Set</b>: The list is cleared first, and then the <c h=@/tgtTabs>target tabs</c> are added. <hr b=2>\n <b>Remove</b>: The <c h=@/tgtTabs>target tabs</c> are removed from the list."},
openBookmarks:{_:" Open a single bookmark or all <br> bookmarks inside a folder.\n ",opnTgtTbs:" You have to specify (in the action's <c h=@/tgtTabs>target tabs</c>) which tab to use for <br> opening the bookmark.\n If you specify more than one tab, the bookmark <br> will be opened on each of those tabs.  \n <hr b=2>\n If you choose a bookmark folder instead, then each bookmark in the <br> folder will be opened in one of the\n <c h=@/tgtTabs>target tabs</c>.\n <{MORE}> <hr b=2>\n Also, remember that in an <c h=@/actChain>action chain</c>, the target tabs are passed on <br> from one action to the next.\n So, the target tabs of the <act xsml inln>Open bookmarks</act> <br> action may be either those specified in the <u b>Apply to</u>\n select box or the <br> ones that came from a previous action in the chain.\n ",
nwTb:" <{../loadUrls/nwTb}>"},bookmarkTabs:{_:" Add one or more tabs to your bookmarks.\n ",flr:" The folder in which the bookmarks will be created. <br> This field cannot be left blank.\n ",pth:" You can optionally specify a name for the bookmark as well as a containing <br> subfolder or subfolder path (using slash characters as separators).\n <hr b>\n You can use <c h=/plcHld>placeholder</c> expressions like <c hl0 blk mnsp>&lt;title&gt;</c>,\n <c hl0 blk mnsp>&lt;domain&gt;</c>, <c hl0 blk mnsp>&lt;date&gt;</c> <br> and others. <hr b>\n If omitted, it defaults to <c blr hl0 blu mnsp>&lt;title&gt;</c>, i.e. no subfolder and the bookmark <br> name will be the page title.\n <{pth2}>\n ",
pth2:` <{MORE}> <hr b=2>\n Specifying a subfolder path here is useful if that path doesn't exist yet or if <br> it depends on variables such as the\n page's <c h=/domPrt>domain</c>, the current date, etc. <hr b>\n For example, the following path expression: <hr b=2>\n <b hl blk mnsp><c prpl>&lt;domain&gt;</c>/Year <c red>&lt;date('Y')&gt;</c>/<c blu>&lt;title&gt;</c></b> <hr b=2>\n will translate to: <hr b>\n <c hl0><c prpl>www.example.com</c> <b>/</b> Year <c red>${_ql(new Date,"Y")}</c> <b>/</b> <c blu>Title of the page</c></c> <hr b=2>\n i.e. the bookmark name will be <u>Title of the page</u> and it will be saved in the <br> folder <u>Year ${_ql(new Date,
"Y")}</u>,\n which in turn is inside the folder <u>www.example.com</u>. <hr b>\n If the folders don't exist, they will be created.\n `,ord:" How to determine the insertion point of the new <br> bookmark in the destination folder. <br>\n The existing bookmarks and folders won't be reordered. <br> Only the new bookmark will be positioned according to <br> the order specified here.\n ",pri:" <b>Folders first:</b> The new bookmark will be inserted <u>after</u> all folders. <hr b>\n <b>Bookmrks first:</b> The new bookmark will be inserted <u>before</u> all folders. <hr b>\n <b>Intersperse:</b> No distinction between bookmarks and folders.\n ",
ifEx:" What to do if there already is a bookmark with the same <br> <c h=/url>URL</c> in the destination folder: <hr b=2>\n <b u>Replace:</b> The existing bookmark will be removed before <br> inserting the new one according to the <b>Insertn order</b>. <hr b=2>\n <b u>Update:</b> The existing bookmark will remain in its current <br> position and only its name will be updated.\n "},bookmarkUrls:{_:" Add a single or multiple URLs to your bookmarks.",flr:" <{../bookmarkTabs/flr}>",ord:" <{../bookmarkTabs/ord}>",
pri:" <{../bookmarkTabs/pri}>",ifEx:" <{../bookmarkTabs/ifEx}>",tbPlh:" <hr b> If you use placeholders that refer to tab's data (such as <c hl0 mnsp>&lt;title&gt;</c>, <c hl0 mnsp>&lt;url&gt;</c>, <br>\n <c hl0 mnsp>&lt;domain&gt;</c>, <c hl0 mnsp>&lt;path&gt;</c>, etc.) the action will repeat itself for each tab you <br> specify in\n the <b u>Apply to:</b> field.\n ",pth:" The name of the new bookmark. You can use <c h=/plcHld>placeholder</c> expressions like <br> <c hl0 blk mnsp>&lt;clipboard&gt;</c>,\n <c hl0 blk mnsp>&lt;selection&gt;</c>, <c hl0 blk mnsp>&lt;title&gt;</c>, etc. <hr b>\n You can additionally specify a subfolder or a path of subfolders separated <br> by slash characters.\n <{tbPlh}>\n <{../bookmarkTabs/pth2}>\n ",
url:" The URL of the new bookmark. <br> You can use <c h=/plcHld>placeholder</c> expressions like <c hl0 blk mnsp>&lt;clipboard&gt;</c>,\n <c hl0 blk mnsp>&lt;selection&gt;</c>, <br> <c hl0 blk mnsp>&lt;url&gt;</c>, etc.\n <{tbPlh}>\n "},focusWin:{_:" Change the <c h=/focWin>focused</c> state of a window.\n ",mode:" Whether to <b>focus</b>, <b>unfocus</b> or change to <br> the opposite state (<b>toggle</b>). <br>\n When a window is unfocused, the window <br> right below it will become focused.\n ",
pk:" Whenever a Chrome window becomes the <c h=/focWin>focused window</c>, <br> its <c h=/actTab>active tab</c>\n is moved to the top of the <c h=/mruOrd>MRU order</c>. That is, <br> it becomes the most recently used tab. <hr b>\n Check this option if you want to keep the window's active <br> tab in its current place in the MRU order.\n "},moveResizeWins:{_:" Change the size and position of one or more <br> windows across single or multiple monitors.\n ",uni:" Unit used for the <c hl0>X</c>, <c hl0>Y</c>, <c hl0>Width</c> and <c hl0>Height</c> fields. <hr b>\n <b>Pixels</b>: Each field specifies an amount of pixels. <hr b>\n <b>Tiles</b>: Each field specifies an amount of tiles in a grid. <hr b>\n <b>%</b>: Each field specifies a percentage of the window's width/height. <hr b=2>\n Click on the <b>Preview result</b> button to see a live preview.\n ",
xy:" <hr b> An <b>absolute</b> value is relative to the <u>monitor</u>'s top-left corner. <br>\n A <b>relative</b> value is relative to the <u>window</u>'s current top-left corner. <hr b>\n Positive and negative values are accepted. <{xywh}>\n ",xywh:" <br> Leave the field empty for no change.",x:" The new horizontal position for the window. <{xy}>",y:" The new vertical position for the window. <{xy}>",w:" An <b>absolute</b> value represents the new width. <br> A <b>relative</b> value represents how much to increase <br> or reduce the width. <{xywh}>",
h:" An <b>absolute</b> value represents the new height. <br> A <b>relative</b> value represents how much to increase <br> or reduce the height. <{xywh}>",mon:" Which monitor to use as a point of reference <br> for absolute positioning. <br>\n <u b>Containing monitor</u> amounts to the monitor <br> where the <c h=@/tgtWin>target window</c> currently is."},fitWinsToGrid:{_:" Resize and reposition one or more windows <br> to the closest size and position that makes <br> them fit into a grid. <br>\n The grid can encompass multiple monitors."},
tileWins:{_:" Tile windows in rows, columns, squares, across <br> multiple monitors... you name it.",x:" Horizontal position of the tiling area, <br> expressed in number of tiles.",y:" Vertical position of the tiling area, <br> expressed in number of tiles.",c:" Width of the tiling area, <br> expressed in number of tiles.",r:" Height of the tiling area, <br> expressed in number of tiles.",mon:" Which monitor to use as a point of reference <br> for positioning the tiling area. <br>\n <u b>Containing monitor</u> amounts to the monitor <br> where the first <c h=@/tgtWin>target window</c> is.\n ",
ani:" Smooth transition, in seconds, from the window's current state <br> to the new state. Set to <u>zero</u> for an instantaneous change."},winActPrev:{win:" Choose a window to preview the action's result. <hr b> <b>Before</b>: shows the window's current placement. <br>\n <b>After</b>: shows the placement after applying the action. <hr b>\n Try moving and resizing the chosen window. The <br> preview will update automatically when you do.\n ",til:" The <c h=@/tgtWin>target windows</c> will be placed on each tile of the red area. <hr b>\n A stronger shade of red in a tile means that more than one <br> window will be placed on that tile. <hr b>\n Tiles are filled from left to right and top to bottom. If there are <br>\n more windows than tiles, the extra windows will fill the tiles <br> again from the top-left."},
sendWinsToBottom:{_:" Send windows to the bottom of the desktop, <br> underneath all other windows."},minimizeWins:{mod:" Whether to <b>minimize</b>, <b>unminimize</b> or <br> change to the opposite state (<b>toggle</b>)."},maximizeWins:{mod:" Whether to <b>maximize</b>, <b>unmaximize</b> or <br> change to the opposite state (<b>toggle</b>)."},fullscreenWins:{mode:" Whether to set fullscreen mode, go back to normal <br> or change to the opposite state (<b>toggle</b>)."},topmostWins:{_:" Set a window to be <c h=/aotWin>always on top</c> of the others.\n ",
mode:" Whether to set/unset <c h=/aotWin>topmost mode</c> or change <br> to the opposite state (toggle)."},hideWins:{_:" Hide or unhide one or more windows. <hr b> Hiding a window is like minimizing it, except the <br>\n window will also disappear from the taskbar and <br> task switcher. <hr b> Nobody will know the window is there, only you.\n ",mode:" Whether to <b>hide</b>, <b>unhide</b> or change to the <br> opposite state (<b>toggle</b>). <hr b>\n Make sure you also define a shortcut to <br> unhide a window after you hid it."},
noAnim:" State changes on a window are usually performed with an animated <br> effect (unless you've disabled it in your operating system settings). <hr b>\n Check this option to perform the action without that animation.\n ",restoreWins:{_:" Change the state of one or more windows to a <br> <b>restored</b> state. Also called <b>normal</b> state.\n That is, <br> not minimized, maximized or fullscreen."},scrollWins:{_:" Scroll the content of one or more windows in any <br> direction (up, down, left, right). <hr b>\n The <c h=@/tgtWin>target windows</c> don't need to be <c h=/focWin>focused</c>, but <br> they must be at least partially visible,\n i.e. they can <br> be overlapped but not entirely.\n ",
amn:" How much to scroll in the desired direction. <br> One unit is equivalent to turning the scroll <br> wheel one notch.\n ",pnt:" Scroll the element under the mouse pointer instead of the <br> <c h=@/tgtWin>target window</c>. <hr b>\n With this option checked, the scroll action can work on any <br> window of any program, whether they are <c h=/focWin>focused</c> or not.\n ",mtd:" Each scrolling method may work better than the others depending on: <hr b>\n <it></it>Which modifier keys are held down while the scroll action is done. <hr b>\n <it></it>The amount of scroll being performed. <hr b>\n <it></it>Whether the window is focused or not. <hr b>\n <it></it>Type of program the window belongs to. <hr b=2>\n <it></it>Number of windows being scrolled simultaneously. <hr b=3>\n Prefer the standard method if you see no difference between each method. <hr b=2> \n <b u>Standard scroll</b>: Standard method supported by most modern programs. <hr b=2>\n <b u>Wheel turn</b>: Scrolling via a synthetic wheel turn. Behaves similar to the <br> standard method. <hr b=2>\n <b u>Legacy scroll</b>: Old method that works even on very old programs. However, <br> it may not produce a smooth scroll effect on some programs.\n ",
kms:" Combine the scroll action with the current state of the modifier keys <br> (<key>Ctrl</key>, <key>Shift</key>, <key>Alt</key>, <key>Win</key>). <hr b=2>\n Depending on the scroll method chosen above, different programs <br> will react differently to a scroll action if modifier keys are held down. <br>\n For example, in most browsers, doing CTRL+Scroll results in a zoom <br> action instead. <hr b>\n If this option is not checked, then the modifier keys will not affect <br> the scroll action. <hr b>\n This option may also be useful to avoid the side effects when <br> pressing <key>Alt</key> or <key>Win</key>,\n which may focus the menu bar or trigger <br> the Start Menu. \n "},
openMenu:{_:" Show a <c h=@/menu>menu</c> on the screen at a <br> given position and alignment.\n ",mnu:' You can choose a predefined <c h=@/menu>menu</c> or click on <u>New menu</u> to <br> define your own. <hr b>\n Only one AutoControl menu can be visible at a time. If the chosen <br> menu is already open when this action is executed,\n nothing will <br> be done. If a different menu is already open, it will be closed first. <hr b=2>\n Once a menu is open, you can select menu items using <br> <c h="../mnuSltn/desc">3 different methods</c>.\n ',
pos:" <{/menuEditor/pos}> <hr b> Leave it blank to use the menu's default.",alg:" <{/menuEditor/alg}> <hr b> Leave it blank to use the menu's default.",sty:" <{/menuEditor/sty}> <br> Leave it blank to use the menu's default."},closeMenu:{mnu:" If you choose a menu here, the action will be done <br> only when that menu is visible. If you leave this field <br>\n blank, the action will be applied to whichever menu <br> is visible at the time. <hr b>\n Menu actions apply to <c h=@/menu>AutoControl menus</c> only.\n "},
moveSelectMark:{_:" <{../mnuSltn/itMrk}> <hr b> Use this action to move the item <br> mark forward or backwards.",mnu:" <{../closeMenu/mnu}>",dir:" Move the <c h=../mnuSltn/itMrk>item mark</c> forward (positive number) <br> or backwards (negative number)."},mnuSltn:()=>"file55.js",selectMarkedItem:{_:' Selects a menu item in the currently open menu. This has the same <br> effect as selecting the item manually with the mouse or keyboard. <br>\n That is, the <c h="../mnuSltn/desc2">default action</c> associated with the item will be performed. <hr b=2>\n However, the menu will remain open. In order to close the menu as <br> well, you can <c h=@/actChain>chain</c> two actions, like this: <hr b=2>\n <center><mid><act>Select menu item</act> <sep></sep> <act>Close menu</act></mid></center>\n ',
mnu:" <{../closeMenu/mnu}>\n ",mkT:" Which item will be selected. <hr b=2>\n <b>Marked:</b> <{../mnuSltn/selTypes/mrkd}> <hr b=2>\n <b>Highlighted:</b> <{../mnuSltn/selTypes/hltd}> <hr b=2>\n <b>Hovered:</b> <{../mnuSltn/selTypes/hvrd}>\n ",mde:" <{../mnuSltn/mode2}>\n "},clbrdOp1:" Performs the <c h=/clpbrd>clipboard</c>'s",clbrdOp2:" operation on the <br> <c h=/focWin>focused window</c>, regardless of what program <br> that window belongs to.",clpbrdCut:{_:"<{../clbrdOp1}> CUT <{../clbrdOp2}>"},
clpbrdCopy:{_:"<{../clbrdOp1}> COPY <{../clbrdOp2}>"},clpbrdPaste:{_:"<{../clbrdOp1}> PASTE <{../clbrdOp2}>"},noProtPags:"<b>Limitation:</b> This action does not work on <c h=/protPg>protected pages</c>.\n ",copyElemUrl:{_:" <{/noSuprt}>\n If the mouse is hovering over any element with an underlying <c h=/url>URL</c>, such <br> as links, images, videos, frames, etc.,\n this action will copy that URL to the <br> clipboard. <br>\n If no URL is found under the mouse, the clipboard will result empty.\n <hr b=2> <{../noProtPags}> <{pnt}>\n ",
pnt:' <{MORE}> <hr b=3>\n If this action is triggered by a mouse gesture, then the URL is obtained <br> from the gesture\'s starting point instead of\n the mouse\'s current point. <br> i.e. you can begin a gesture over a link or image and end the gesture <br> outside that link/image.\n See examples <a href="<{/URLS/hvrGest}>">here</a>. <hr b=2>\n Similarly, if this action is triggered from an <c h=@/menu>AutoControl menu</c>, then <br> the URL is obtained from the point the mouse was\n when opening the <br> menu and not from the point the mouse is when clicking a menu item. <br>\n See examples <a href="<{/URLS/hvrMnuAct}>">here</a>.\n ',
tpe:" Choose what types of elements to look for. <u>Only the first</u> element <br> found that <u>matches the chosen types</u> will be copied. <hr b=2>\n <c b>Link</c>: Any clickable element that navigates to another page or <br> begins a file download. <hr b>\n <c b>Media</c>: Any embeddable resource such as images, videos, audio <br> players, etc. <hr b>\n <c b>Frame</c>: A webpage inside a webpage. For example, Youtube videos, <br> Instagram posts, advertisement\n blocks, etc. are embedded in other <br> websites using a frame.\n <{MORE}> <hr b=2>\n There may be more than one type of element under the mouse cursor. <br> For example, an <u>image</u> can also be a <u>link</u>\n and be inside a <u>frame</u>. In this <br> case, the first element found will be the image because it's the innermost. <br>\n If you want the link instead, check the <b>Link</b> element type only.\n <{pnt}>\n ",
smt:" Some websites try to hide media elements from the mouse <br> cursor by putting transparent elements on top\n (e.g. Twitter <br> and Instagram). Check this option to break through all that <br> and find the underlying URL no matter what.\n ",tgt:" Which clipboard to copy the URL to. \x3c!--The extra clipboards <br> are memory slots kept by AutoControl.--\x3e <hr b>\n You can then use the copied URL in other actions (such as <br> the <act inln xsml>open url</act> action) by means of the\n <c hl0 mnsp blk>&lt;<c h=@/tmplExpr/clbrd>clipboard</c>&gt;</c> <br> <c h=/plcHld>placeholder</c>. <hr b>\n Prefer using one of the <c h=@/exClbrd>extra clipboards</c> so as to leave the <br> system clipboard untouched."},
openElemUrl:{_:" <{/noSuprt}>\n If the mouse is hovering over an element with an underlying <c h=/url>URL</c>, such <br> as links, images, videos, etc.,\n this action will open that URL in a new tab.\n <hr b=2> <{../noProtPags}> <{MORE}> <hr b=3> <b>Tip:</b> <br>\n This action is a simplified version of the following <c h=@/actChain>action chain</c>: <hr b=2>\n <center><mid><act>Copy hovered URL</act> <sep></sep> <act>Open URL</act></mid></center>\n <hr b=2>\n This action chain gives you much more control over what is opened, <br> in which tab and where that tab is positioned.\n <hr b> <{../copyElemUrl/pnt}>\n ",
tpe:" The type of element whose URL will be opened. If no element of this <br> type is found under the mouse cursor, the action will do nothing.\n <hr b=2>\n <b>Link</b>: Any clickable element that navigates to another page. <hr b>\n <b>Media</b>: Any embeddable resource such as images, videos, audio <br> players, etc.\n <{../copyElemUrl/pnt}>\n "},copyLinks:{_:" When you select text in a webpage, if that text includes elements with <br> underlying <c h=/url>URLs</c>, such as links, images, videos, etc.,\n this action will copy <br> the URLs of those elements instead of the text itself. <hr b>\n \x3c!--If no URLs are found, the chosen clipboard will result empty. <hr b> --\x3e\n The text selection will be obtained from the <c h=/focWin>focused window</c>, even if <br>\n that window belongs to a completely different browser, such as Firefox <br> or Internet Explorer. \n ",
tpe:' The types of elements whose underlying <c h=/url>URLs</c> will be copied to <br> the chosen clipboard (one URL <c h=@/txtLn>per line</c>). <hr b>\n <b>Links:</b> Clickable elements that navigate to another page or begin <br> a file download. <hr b>\n <b>Videos:</b> Video player elements. <hr b>\n <b>Audio:</b> Audio player elements. <hr b>\n <b>Images:</b> Photos, pictures and image elements. These elements <br> usually provide the "Save image as..." option in the context menu. <hr b>\n <b>Graphic resources:</b> Images that are embedded as decorative <br> graphic elements. These don\'t have a "Save as..." option in the <br>\n context menu. Some websites embed photos and pictures this <br> way in order to prevent the user from easily downloading them.\n <hr b> <{MORE}> <hr b=3>\n <b>Tip:</b> <br>\n You can use the <key>Ctrl</key>+<key>A</key> standard shortcut to select everything <br> in a webpage.\n Then, you can use the following <c h=@/actChain>action chain</c> to <br> save all images, all links, all videos, etc. <hr b=2>\n <center><mid><act>Copy selected URLs</act><sep></sep><act>Save URL</act></mid></center>\n ',
tgt:" The URLs will be put in this clipboard, one URL <c h=@/txtLn>per line</c>. Any <br> previous content in this clipboard will be removed.\n If no URLs <br> are found in the selected text, this clipboard will result empty. <hr b=2>\n These URLs can then be used in another action by specifying <br> the <c hl0 mnsp>&lt;<c h=@/tmplExpr/clbLns>clipboard(<b red blr>n</b>).lines</c>&gt;</c>\n placeholder in that action. <hr b=3>\n For example: &nbsp; <mid><act xsml>Copy selected URLs</act> <sep></sep> <act xsml>Open URL</act></mid>\n "},
extractURLs:{_:" Extract <c h=/url>URLs</c> from multiple sources of text, such as the current text <br> selection, one or more <c h=/clpbrd>clipboards</c>,\n the <c h=/ombar>omnibox</c>, etc. <hr b>\n The found URLs will be put in a <c h=/clpbrd>clipboard</c> of your choice.\n ",txt:' The text from which the URLs will be extracted. You <br> can enter multiple <c h=@/txtLn>lines of text</c> in this field. <br>\n It can include one or more <c h=/plcHld>placeholders</c> separated by <br> any amount of text in between. <hr b>\n For example, this expression: <br>\n <c ib hl mnsp>&lt;selection&gt;<br>&lt;clipboard(1)&gt;</c> <hr b=2>\n will put together the current text selection and the <br> <c h=@/exClbrd>Extra clipboard 1</c> separated by\n a <a href="<{/URLS/newln}>">newline character</a>. <hr b>\n The resulting body of text is scanned for URLs, which <br> are then saved to the clipboard chosen below.\n ',
tgt:" The found URLs will be put in this clipboard, one URL <c h=@/txtLn>per line</c>. <br> Any previous content in this clipboard will be removed. <br>\n If no URLs are found in the source text, this clipboard will <br> result empty. <hr b=2>\n These URLs can then be used in another action by specifying <br> the <c hl0 mnsp>&lt;<c h=@/tmplExpr/clbLns>clipboard(<b red blr>n</b>).lines</c>&gt;</c>\n placeholder in that action. <hr b=3>\n For example: &nbsp; <mid><act xsml>Extract URLs</act> <sep></sep> <act xsml>Open URL</act></mid>\n "},
txtToUrl:{_:" Turns one or more <c h=@/txtLn>text lines</c> from multiple <br> sources into <c h=/url>well-formed URLs</c>.\n ",txt:' The text that will be turned into <c h=/url>well-formed URLs</c>, <c h=@/txtLn>line by line</c>. <hr b>\n This text can include multiple <c h=/plcHld>placeholders</c> in a single or <br> multiple lines. <hr b>\n For example, this expression <c hl0 mnsp>&lt;clipboard&gt;&lt;omnibox&gt;</c> will <br> join the <c h=/clpbrd>clipboard</c>\n text and the <c h=/ombar>omnibox</c> text into a single piece <br> of text without any separation. <hr b>\n Whereas this expression: <br>\n <c ib hl mnsp>&lt;clipboard&gt;<br>&lt;omnibox&gt;</c> <hr b>\n will join them with a <a href="<{/URLS/newln}>">newline character</a> in between. <hr b=2>\n Each <c h=@/txtLn>line</c> in the resulting body of text will be turned into a URL. <br>\n If a line cannot be turned into a URL, it will be discarded.\n <{MORE}> <hr b=2>\n It\'s also possible to use one or more placeholders that give a <br> list of elements, such as <c hl0 mnsp>&lt;selection.words&gt;</c> <br>\n This will separate the selected text into words and each word <br> will be turned into a URL according to the settings below.\n ',
prot:' Each <c h=@/txtLn>text line</c> (given in the <b>Text</b> field above) that resembles a <br> URL will be turned into a well-formed URL\n by prepending the <br> <c h=/urlPrts>protocol</c> specified here. If omitted, it defaults to "<c blk>http</c>". <hr b=2>\n Examples of text lines that resemble URLs: <br>\n <c mnsp blu> example.com <br> 192.168.0.1 <br> example.co.uk <br> localhost </c> <hr b=2>\n Text lines that do not resemble a URL will be turned into a URL <br> by using the <b>Template</b> below. <br>\n Text lines that already are well-formed URLs won\'t be changed.\n ',
w3:" In addition to the protocol, also add <b>www</b> to <br> the <c h=/mDomPrt>main domain</c> if there are no subdomains.\n ",tmpl:" This template will be used only when a <c h=@/txtLn>text line</c> doesn't resemble a URL. <hr b>\n You must use the <c hl0 mnsp>&lt;text&gt;</c> <c h=/plcHld>placeholder</c> to insert the text line into the template. <hr b>\n If after applying this template, the resulting text still doesn't resemble a URL, the <br> text line will be discarded. <hr b=2>\n For example, this template <c hl0 mnsp>www.&lt;text&gt;.com</c> will turn a text line into a <b>.com</b> <br> URL if the text\n represents a <a href=\"https://wikipedia.org/wiki/Hostname#Syntax\">valid domain name</a>.\n <{MORE}> <hr b=3>\n Additionally, the template can produce multiple <c h=@/txtLn>text lines</c> if it contains one or <br> more <c h=/plcHld>placeholders</c> that give a\n list of elements, such as <c hl0 mnsp>&lt;text.words&gt;</c> or <br> <c hl0 mnsp>&lt;clipboard.words&gt;</c>. <hr b> \n For example, this template <c hl0 mnsp>google.com/search?q=<c prpl>&lt;text.words&gt;</c></c> will <br> produce one Google search URL\n for each word in the text line. <hr b=2>\n A second way of producing multiple text lines is if the template contains one or <br> more placeholders that refer to the\n <c h=@/tgtTabs>target tabs</c> passed to the action, such as the <br> <c hl0 mnsp>&lt;domain&gt;</c> or <c hl0 mnsp>&lt;mainDomain&gt;</c>\n placeholders. <hr b>\n For example, this template: <br>\n <c hl mnsp>google.com/search?q=<c prpl>&lt;text&gt;</c> site:<c prpl>&lt;mainDomain&gt;</c></c> <hr b>\n will produce one URL for each target tab's <c h=/mDomPrt>main domain</c>.\n ",
tgt:" Which <c h=/clpbrd>clipboard</c> to save the URLs to. Once the action executes, <br> this clipboard is guaranteed to contain only\n well-formed URLs <br> (one by <c h=@/txtLn>line</c>) or empty if no text lines could be turned into URLs. <hr b=2>\n These URLs can then be used in another action by specifying <br> the <c hl0 mnsp>&lt;<c h=@/tmplExpr/clbLns>clipboard(<b red blr>n</b>).lines</c>&gt;</c>\n placeholder in that action. <hr b=3>\n For example: &nbsp; <mid><act xsml>Text to URL</act> <sep></sep> <act xsml>Open URL</act></mid>\n "},
delDupLines:{_:" If there are several <c h=@/txtLn>lines of text</c> in the clipboard, <br>\n this action will remove duplicated lines so that <br> all remaining lines are different.\n ",tgt:" Which clipboard to operate with."},clpbrdPut:{_:" Put or append text into a <c h=/clpbrd>clipboard</c>. <br>\n \x3c!--The text can be dependent on the tabs the <br> action is applied to.--\x3e\n ",txt:' The text may contain <c h=/plcHld>placeholder</c> expressions like <c hl0 mnsp>&lt;url&gt;</c>, <br>\n <c hl0 mnsp>&lt;clipboard&gt;</c> and others. <hr b=2>\n <b>Examples:</b> <hr b>\n The expression <c b hl0 mnsp>&lt;url&gt; ;</c> will be expanded to the URLs\n of all <br> <c h=@/tgtTabs>target tabs</c> separated by a semicolon.\n <hr b=3>\n The expression: <c hl mnsp>"&lt;clipboard&gt;" &lt;clipboard(1)&gt; &lt;url&gt;</c> <br> gives the <u>system clipboard</u>\n between quotes followed by the <br> <u>Extra clipboard 1</u> and the URL of the target tab.\n <{@/tmplExpr/proTip}>\n ',
vbm:" Do not replace <c h=/plcHld>placeholder</c> expressions. <br>i.e. insert the text as is.\n ",apn:" Append (instead of replace) the text to <br> the clipboard's current content.\n ",tgt:" Choose the clipboard in which to put the text. <hr b> <{@/exClbrd}>"},insertText:{_:" Insert the given text at the cursor position <br> in the <c h=/focWin>focused window</c>. <br>\n \x3c!--The text can be dependent on the tabs the <br> action is applied to. --\x3e\n ",txt:" <{../clpbrdPut/txt}>",vbm:" <{../clpbrdPut/vbm}>"},
sendInput:()=>"file32.js",stopSendInput:{_:" Stop immediately one or more synthetic-input <br> actions that are still running.",grp:" Stop synthetic-input actions of a specific <br> group or leave it blank to stop all groups."},runCommand:{_:" Open a file or run an external program or command.\n ",cmd:' You can specify any file or program. Either images, videos, music <br> files, programs like the calculator, MS Paint, Firefox, etc. <hr b>\n You can include <c h=/plcHld>placeholder</c> expressions like <b>&lt;url&gt;</b>, <b>&lt;clipboard&gt;</b> <br> and others. <hr b>\n For example, the following can be used to open the <c h=@/tgtTabs>target tab</c> <br> in Firefox: <hr b>\n <c hl>"C:\\Program Files\\Mozilla Firefox\\firefox.exe" <b>&lt;url&gt;</b></c> <{MORE}> <hr b=3>\n The following will start the screensaver immediately: <hr b>\n <c hl>mystify.scr /s</c> <hr b=3>\n You can also run system commands such as <c hl>shutdown /h</c> which <br> will hibernate your computer. Any command supported by the <br>\n system\'s <a target=_blank href="http://wikipedia.org/wiki/Cmd.exe">command prompt</a> is possible.\n \x3c!--\n <hr b=2>\n Batch files can be run in their own command window with the <br>\n <a href="https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/start">start</a>\n command: <c hl>start C:\\path\\to\\file.bat</c> <hr b=2>\n Without the <b>start</b> command, the batch file will run hidden.\n --\x3e\n ',
sh:' Show a <a target=_blank href="http://wikipedia.org/wiki/Cmd.exe">command prompt</a> window in which to execute the <br> command. <br>\n This is only useful if your are executing a command, not if <br> you are opening a file or program. <br>\n If this option is not checked, the command will be executed <br> silently, without any visible cues.\n ',kp:' Keep the <a target=_blank href="http://wikipedia.org/wiki/Cmd.exe">command prompt</a> window open after <br> the command is complete.'},runScript:()=>
"file54.js",setVolume:{_:" Change or mute the audio volume coming from <br> the speakers or the browser. <hr b>\n This action is not supported on Windows XP. \n ",scp:" <b>Global</b>: Change the volume of the speakers. <hr b>\n <b>Browser</b>: Change the volume of any audio coming from the browser. <br>\n This will affect all Chrome tabs and windows even if they belong to a <br> different browser profile.\n "},saveUrl:()=>"file43.js",saveElemUrl:{_:" <{/noSuprt}>\n If the mouse is hovering over an element with an underlying <c h=/url>URL</c>, such <br> as links, images, videos, etc...,\n this action will save the content of that <br> URL to a local file. <br>\n If the filename already exists in the destination folder, a unique name <br> will be generated by appending a number to it. \n <hr b=2> <{../noProtPags}> <{MORE}> <hr b=3> <b>Tip:</b> <br>\n This action is a simplified version of the following <c h=@/actChain>action chain</c>: <hr b=2>\n <center><mid><act>Copy hovered URL</act> <sep></sep> <act>Save URL</act></mid></center>\n <hr b=2>\n This action chain gives you much more control over what is saved, <br> the method used and what to do with the saved files.\n <hr b> <{../copyElemUrl/pnt}>\n ",
dir:" <{../saveUrl/dir}>",aud:" <{../saveUrl/aud}>",ntf:" <{../saveUrl/ntf}>",mgr:" <{../saveUrl/mgr0}>"},brkActSeq:{_:' Continue or stop executing the current <c h=@/actChain>action chain</c> if a condition <br> is true. <br>\n For example, in the following chain, the <b uc sml blr blk>Open URL</b> action will be <br> executed only if the condition inside\n <b uc sml blr blk>Continue chain if</b> is true. <hr b=3>\n <center><mid><act xsml>activate tabs</act> <sep></sep> <act xsml>Continue chain if</act> <sep></sep> <act xsml>Open URL</act></mid></center>\n <hr b=4>\n In other words, if a chain is stopped, none of the remaining <br> actions in that chain are executed. <hr b>\n Learn more about this action at <a href="<{/URLS/condExec}>">Conditional Execution</a>.\n ',
act:` \n The following table shows what will happen depending on what you choose in <br> the "Action:" field and whether the\n condition you added below is <b blu>true</b> or <b blu>false</b>.\n <hr b=2>\n <style>\n [brkActSeq] tr:not(:first-child) td:first-child {text-align: right}\n [brkActSeq] tr:not(:first-child) td {padding: 4px 8px}\n [brkActSeq] tr:first-child {background: hsla(0, 0%, 48%, 0.15)}\n [brkActSeq] td {text-align: center}\n [brkActSeq] td:not(:last-child) {border-right: 1px solid rgba(0, 0, 0, 0.19)}\n </style>\n <table brd brkActSeq>\n <tr><td>Action field <td>If the condition is <b blu>true</b> <td>If the condition is <b blu>false</b>\n <tr><td><b>Continue chain</b> <td><c prpl>Continue</c> <td><c prpl>Stop current chain</c>\n <tr><td><b>Stop chain</b> <td><c prpl>Stop current chain</c> <td><c prpl>Continue</c>\n <tr><td><b>Stop entire sequence</b> <td><c prpl>Stop all chains</c> <td><c prpl>Continue</c>\n </table>\n <hr b=3>\n If you don't add any condition below, it defaults to a <b blu>true</b> condition.\n <{MORE}> <hr b=3>\n Here is the meaning of the purple text in the table: <hr b=2>\n <c prpl>Continue</c>: The current <c h=@/actChain>action chain</c> as well as all remaining chains will execute <br> normally.\n <hr b=2>\n <c prpl>Stop current chain</c>: None of the remaining actions in the current chain will be <br> executed. Execution will continue at the next chain, if one exists.\n <hr b=2>\n <c prpl>Stop all chains</c>: None of the remaining actions in the current chain will be <br> executed and none of the following chains will be executed either. \n <hr b=3>\n Learn more about action chains and sequences at <a href="${_Ce.actions}">this page</a>.\n `,
adCnd:" You can add one or more conditions that will determine <br> if the <c h=@/actChain>action chain</c> is allowed to continue or not. <br>\n If you don't add any condition, the action behaves as if <br> the condition is always true. <hr b=2>\n There are 3 types of conditions, as shown below. You can <br> add any number of conditions of any type. <hr b>\n <style>[bull]::before {content: '\\2023'; font: bold 110%/1 sans-serif; margin: 0 1px 0 2px;}</style>\n <c bull></c> <c h=tgtTabs><b>Target tabs</b> condition</c> <hr b>\n <c bull></c> <c h=swtchSt><b>Switch</b> condition</c> <hr b>\n <c bull></c> <c h=txtMtch><b>Text</b> condition</c>\n ",
oper:" Each condition is combined with the next using the operators <br> <b>AND</b>, <b>OR</b> or <b>EQUAL</b>. <hr b=2>\n <b>For example:</b> <hr b=2>\n <c hl blu>Condition 1</c> &nbsp; <b>OR</b> <hr b>\n <c hl blu>Condition 2</c> &nbsp; <b>AND</b> <hr b>\n <c hl blu>Condition 3</c> <hr b=2>\n The combination of these 3 conditions will be <c prpl blr>true</c> when either <br> <c blu>Condition 1</c> <b>OR</b>\n <c blu>Condition 2</c> are <c prpl blr>true</c> <b>AND</b> <c blu>Condition 3</c> is also <c prpl blr>true</c>. <br>\n That is, <c blu>Condition 1</c> or <c blu>Condition 2</c> can be <c prpl blr>false</c>, but not both.\n <{MORE}> <hr b=3>\n <b>Another example:</b> <hr b=2>\n <c hl blu>Condition 4</c> &nbsp; <b>EQUAL</b> <hr b>\n <c hl blu>Condition 5</c> &nbsp; <hr b=2>\n The combination of these 2 conditions will be <c prpl blr>true</c> when both <br> conditions have the same truth value,\n i.e. when they are both <c prpl blr>true</c> <br> or both <c prpl blr>false</c>.\n <{MORE}> <hr b=3>\n <b>Last example:</b> <hr b=2>\n <c hl blu>Condition 1</c> &nbsp; <b>OR</b> <hr b>\n <c hl blu>Condition 2</c> &nbsp; <b>AND</b> <hr b>\n <c hl blu>Condition 3</c> &nbsp; <b>EQUAL</b> <hr b>\n <c hl blu>Condition 4</c> &nbsp; <hr b=2>\n The combination of these 4 conditions will be <c prpl blr>true</c> when the <br> combination of the first 3 conditions has the same\n truth value as <br> the last condition. That is, conditions are always combined in <br> order from top to bottom. \n ",
tgtTabs:" The <b>target tabs</b> condition checks if the amount of <c h=@/tgtTabs>target tabs</c> <br> passed to this action equals a given\n quantity or range. <hr b=2>\n If the <act xsml>Continue chain if</act> action is the first one in the <c h=@/actChain>chain</c>, <br>\n the <c h=@/tgtTabs>target tabs</c> come from the <b u>Apply to</b> select box. Otherwise, <br> the target tabs come from the previous action in the chain.\n ",swtchSt:" The <b>switch</b> condition checks if the state of <br> a <c h=/switch>SWITCH</c> is either ON or OFF.\n ",
txtMtch:' The <b>text</b> condition checks whether two text snippets compare to each other. <br>\n The snippets can contain <c h=/plcHld>placeholder</c> expressions like <c hl0 mnsp>&lt;url&gt;</c>, <c hl0 mnsp>&lt;clipboard&gt;</c>, <br>\n <c hl0 mnsp>&lt;selection&gt;</c> and many others. Use the drop-down menu on each text field <br> to see the most common ones.\n <{MORE}> <hr b=2>\n <b>Examples:</b> <hr b=2>\n <c hl>&lt;mainDomain&gt; <c blu>equals</c> youtube.com</c> <br>\n This condition will be true if the <c h=/mDomPrt>main domain</c> of the <c h=@/tgtTabs>target tab</c> is youtube.com.\n <hr b=3>\n <c hl>&lt;clipboard&gt; <c blu>starts with</c> hello</c> <br>\n This condition will be true if the clipboard starts with the word "hello".\n <hr b=3>\n <c hl>&lt;selection&gt; <c blu>contains</c> &lt;clipboard&gt;</c> <br>\n This condition will be true if the current text selection contains whatever text is <br> in the clipboard.\n '},
setSwtchSt:{_:" Use this action to change the state of a <c h=/switch>SWITCH</c>.",swt:" Choose the <c h=/switch>SWITCH</c> whose state you want to set.",act:" Whether to turn the switch <b>ON</b>, <b>OFF</b> or <br> to <b>toggle</b> it to its opposite state."},wait:{_:` This action is used to delay the execution of the remaining <br> actions in the <c h=@/actChain>action chain</c> and\n <a href='${_Ce.actions}#sequence'>unchained sequence</a>. <hr b>\n The delay can last for a fixed amount of time or until an <br> event occurs. <hr b>\n For example, in the following chain, there will be a delay <br> between <b uc sml blk>Open URL</b> and <b uc sml blk>Activate tabs</b>: <hr b=2>\n <center><mid><act xsml>Open URL</act> <sep></sep> <act xsml>Wait</act> <sep></sep> <act xsml>Activate tabs</act></mid></center> \n `,
wfr:" Choose whether to wait for a fixed amount of time or for an <br> event to occur. <br>\n In the case of tab events and window events, the action will <br> wait for the event to occur in ALL <c h=@/tgtTabs>target tabs</c>. <hr b>\n For window events, the <c h=@/tgtTabs>target tabs</c> must include at least one <br> tab of each window you want to wait for. <br>\n For example, if you need to wait for 2 windows to be closed, <br> the <c h=@/tgtTabs>target tabs</c> must include at least one tab of each window.  \n ",
tim:" Time to wait for, in seconds and fractions of a second.\n ",tmo:" If the wait is still ongoing after this amount of seconds, the <br> wait will stop and the <b u>If timeout</b> option will take effect.\n ",ifto:" What to do if the timeout is reached or if no <c h=@/tgtTabs>target tabs</c> were <br> passed to the action (for tab/window events): <hr b=2>\n <b u>Continue chain:</b> The <c h=@/actChain>action chain</c> will continue normally. <hr b=2>\n <b u>Stop chain:</b> The <c h=@/actChain>action chain</c> will stop. Execution will continue <br> at the next chain, if one exists. <hr b=2>\n <b u>Stop entire sequence:</b> The current <c h=@/actChain>action chain</c> will stop and <br> no following chains are executed.\n If there are no more action <br> chains, this option has the same effect as <b>Stop chain</b>.\n ",
sync:" Postpone all other AutoControl actions while this action is waiting. <br>\n i.e. none of your shortcuts will respond immediately during the wait. <br> Instead, they will be delayed until the wait is finished. <hr b>\n This guarantees that all actions are executed in the order they were <br> fired by their respective triggers,\n which is useful to prevent different <br> <c h=@/actChain>action chains</c> from interspersing with one another. <br>\n This is the normal behavior of all actions, and this checkbox makes <br> the <act xsml inln>Wait</act> action behave like all the others. <hr b>\n If you do not enable this option, other triggers will fire their actions <br> immediately while this action is still waiting. \n "},
playAudio:{_:" Plays a variety of sounds and audio files in any <br> format supported by the browser. <br>\n It can also produce audible speech from any <br> piece of text.\n ",typ:" <b>Preset sound:</b> Play a sound that comes included with the extension. <hr b>\n <b>System sound:</b> Play any of the sounds that can be configured in the <br> Windows Control Panel. <hr b>\n <b>Sound file:</b> Play any sound file from your hard drive. It supports <br> common file formats such as .wav, .mp3, .m4a, .wma, .webm, etc. <hr b>\n <b>Speech:</b> Produce audible speech from text in any supported language.\n ",
evt:" These are the system events that are associated to <br> sound files in the Windows Control Panel.\n ",fle:" You can choose any file from your hard drive. Most common file <br> formats are supported (.wav, .mp3, .m4a, .wma, .webm, etc.). <hr b=3>\n <b>CAUTION:</b> The <act inln xsml>Play audio</act> action is designed to play files of short <br> duration. Don't use it as a music player.\n If you wish to play music <br> files, you should use the <act inln xsml>Open file/program</act> action instead. \n ",
len:" How long the sound must be, in seconds.\n ",lnp:" Durations over 100% will stretch the sound, giving it a lower pitch. <br>\n Durations under 100% will compress the sound, giving it a higher pitch.\n ",frq:' The pitch in <a href="https://wikipedia.org/wiki/Hertz">Hertz</a> of the sound\'s dominant frequency. <hr b=2>\n These are the frequencies of common musical notes: <hr b>\n <style>\n [noteFreq] {display: flex; flex-direction: column; flex-wrap: wrap; max-height: 13ex; margin: 0 0 0 6px}\n [noteFreq] c {display: flex; height: 3ex; align-items: center; margin: 0 32px 0 0px; justify-content: space-between; color: hsla(100,100%,25%,1)}\n [noteFreq] n {font-weight: bold; width: 4ex; color: black}\n </style>\n <div noteFreq>\n <c><n>C </n> 261.6 Hz</c>\n <c><n>C# </n> 277.2 Hz</c>\n <c><n>D </n> 293.7 Hz</c>\n <c><n>D# </n> 311.1 Hz</c>\n <c><n>E </n> 329.6 Hz</c>\n <c><n>F </n> 349.2 Hz</c>\n <c><n>F# </n>  370 Hz</c>\n <c><n>G </n>  392 Hz</c>\n <c><n>G# </n>  415.3 Hz</c>\n <c><n>A </n>  440 Hz</c>\n <c><n>A# </n>  466.2 Hz</c>\n <c><n>B </n> 493.9 Hz</c>\n </div>\n <hr b=2>\n See full table <a href="https://wikipedia.org/wiki/Scientific_pitch_notation#Table_of_note_frequencies">here</a>.\n ',
tms:" How many times to repeat the sound.\n ",gap:" Time gap between each repetition, as a percentage <br> of the sound's duration. <br> Negative values are allowed,\n i.e. each repetition will <br> overlap the previous one by the specified percentage.\n ",vol:' 100% is the maximum volume the speakers can <br> produce without distortion. <br> More than 100% may produce speaker saturation <br>\n (an effect known as <a href="https://wikipedia.org/wiki/Clipping_(audio)">clipping</a>).\n ',bal:" <b>Center:</b> Both speakers are used. <hr b>\n <b>Left:</b> Only the left speaker is used. <hr b>\n <b>Right:</b> Only the right speaker is used. <hr b>\n <b>Left to right:</b> The sound will move from left to right. <hr b>\n <b>Right to left:</b> The sound will move from right to left.\n ",
txt:" The text to speak. <br>\n It can contain <c h=/plcHld>placeholders</c> such as <c hl0 mnsp>&lt;selection&gt;</c>, <br> <c hl0 mnsp>&lt;clipboard&gt;</c>,\n <c hl0 mnsp>&lt;title&gt;</c>, etc.\n \x3c!--\n <hr b=3>\n In order to speak the selected text from the <c h=/focWin>focused window</c>, use the <br> <act inln xsml>Clipbrd copy</act> action\n to first copy the text to the <c h=/clpbrd>clipboard</c>, like this: <hr b=2>\n <center><mid><act inln xsml>Clipbrd copy</act> <sep></sep> <act inln xsml>Play audio</act></mid></center>\n --\x3e\n ",
lng:" The language of the text. <br> These are all the languages supported by your browser.\n ",mde:" <b>Overlap:</b> Play the audio immediately, without waiting <br> for other audio to finish. <hr b>\n <b>Enqueue:</b> Play the audio after any currently playing <br> audio is finished. <hr b>\n <b>Interrupt:</b> Any currently playing audio is immediately <br> stopped before playing this audio.\n "},setMonBright:{_:" Change the brightness of one or more of your monitors. <hr b>\n This changes the backlight intensity, not the image colors. <br> i.e. it's the same as changing the monitor's on-screen <br> brightness setting. \n <hr b=2> <{caveat}>\n ",
caveat:'For this to work on external monitors, you must enable <br> the <a href="https://en.wikipedia.org/wiki/Display_Data_Channel#DDC/CI">DDC/CI</a>\n option in your monitor\'s on-screen menu.\n ',mon:" <b>All monitors:</b> Apply the action to all your monitors. <hr b=2>\n <b>Focused monitor:</b> Apply the action to the monitor <br> containing the <c h=/focWin>focused window</c>. <hr b=2>\n <b>Hovered monitor:</b> Apply the action to the monitor <br> containing the mouse cursor. <hr b=2>\n <b>Purple items:</b> Apply the action to that specific monitor. <hr b=3>\n <{caveat}>\n ",
amn:" Minimum brightness level is 0 and maximum is 100."},showDesktop:{_:' Executes the "Show desktop" system command. This has identical <br> effect as clicking the "Show desktop" icon next to the\n <c h=/sysTr>notification area</c>. <br> Executing this action a second time makes the windows visible again. <hr b=2>\n <b>NOTE:</b> <br> In order to execute this action a second time, the trigger must have <br> the <c h=/triggers/brwSt>Browser state</c>\n condition set to <b blu>Unfocused</b> because the first time <br> the action is executed, all windows are minimized,\n i.e. the browser is <br> no longer focused.\n '},
screenSaver:{_:" Starts the screen saver immediately, without waiting <br> for the necessary period of inactivity."},setMonPower:{_:" Powers off the computer screen immediately, without <br> waiting for the necessary period of inactivity."}}};
